/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.base;

import filenet.vw.api.IVWTableDefinition;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.base.VWConfigTableModelData;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class VWConfigSystemFieldTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 4;
    public static final int COLUMN_STATUS = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_TYPE = 2;
    public static final int COLUMN_LENGTH = 3;
    private Frame m_parentFrame = null;
    private IVWTableDefinition m_vwTableDef = null;
    private Vector m_rowData = null;
    private Vector m_availableOptions = null;
    private Vector m_selectedOptions = null;
    private boolean m_bIsModified = false;
    private VWSession m_vwSession = null;

    public VWConfigSystemFieldTableModel(Frame parent, IVWTableDefinition tableDefinition, VWSession session) {
        this.m_parentFrame = parent;
        this.m_vwTableDef = tableDefinition;
        this.m_vwSession = session;
        this.initialize();
    }

    public String[] getAvailableFields() {
        return this.getFieldNames(this.m_availableOptions);
    }

    public boolean getCanDeleteRow(int nRowIndex) {
        try {
            VWExposedFieldDefinition fieldDef = this.getFieldItemAt(nRowIndex);
            if (fieldDef != null) {
                return !fieldDef.isMandatorySystemField();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return true;
    }

    public String[] getSelectedFields() {
        return this.getFieldNames(this.m_selectedOptions);
    }

    public boolean isModified() {
        return this.m_bIsModified;
    }

    public void setSelectedFields(String[] selectedFieldNames) {
        int nIndex = -1;
        VWExposedFieldDefinition fieldDef = null;
        VWConfigTableModelData tableData = null;
        try {
            if (selectedFieldNames != null) {
                for (nIndex = 0; nIndex < selectedFieldNames.length; ++nIndex) {
                    fieldDef = this.moveToSelectedList(selectedFieldNames[nIndex]);
                    if (fieldDef == null) continue;
                    try {
                        fieldDef = this.m_vwTableDef.createFieldDefinition(fieldDef.getName(), fieldDef.getFieldType(), fieldDef.getLength());
                        tableData = new VWConfigTableModelData(fieldDef, 42);
                        if (tableData != null) {
                            this.m_rowData.addElement(tableData);
                        }
                        this.m_bIsModified = true;
                        continue;
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                        VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), 1);
                    }
                }
            }
            for (nIndex = this.m_selectedOptions.size() - 1; nIndex >= 0; --nIndex) {
                boolean bFound = false;
                fieldDef = (VWExposedFieldDefinition)this.m_selectedOptions.elementAt(nIndex);
                if (selectedFieldNames != null) {
                    for (int i = 0; i < selectedFieldNames.length; ++i) {
                        if (VWStringUtils.compare(selectedFieldNames[i], fieldDef.getName()) != 0) continue;
                        bFound = true;
                        break;
                    }
                }
                if (bFound) continue;
                String fieldName = fieldDef.getName();
                try {
                    this.m_vwTableDef.deleteFieldDefinition(fieldName);
                    this.moveToAvailableList(fieldName);
                    for (int nRowIndex = this.m_rowData.size() - 1; nRowIndex >= 0; --nRowIndex) {
                        fieldDef = this.getFieldItemAt(nRowIndex);
                        if (VWStringUtils.compare(fieldName, fieldDef.getName()) != 0) continue;
                        this.m_rowData.removeElementAt(nRowIndex);
                        break;
                    }
                    this.m_bIsModified = true;
                    continue;
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), 1);
                }
            }
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void deleteItem(int nRowIndex) {
        try {
            String name;
            VWExposedFieldDefinition fieldDef = this.getFieldItemAt(nRowIndex);
            if (fieldDef != null && !fieldDef.isMandatorySystemField() && (name = fieldDef.getName()) != null && name.length() > 0) {
                this.m_vwTableDef.deleteFieldDefinition(name);
                this.moveToAvailableList(name);
                this.m_rowData.removeElementAt(nRowIndex);
                this.m_bIsModified = true;
                this.fireTableRowsDeleted(nRowIndex, nRowIndex);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), 1);
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return new String(" ");
            }
            case 1: {
                return VWResource.FieldName;
            }
            case 2: {
                return VWResource.FieldType;
            }
            case 3: {
                return VWResource.Length;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size();
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        VWExposedFieldDefinition fieldDef = null;
        try {
            VWConfigTableModelData tableData = this.getRowItemAt(nRowIndex);
            if (tableData != null) {
                fieldDef = (VWExposedFieldDefinition)tableData.getDefinition();
            }
            switch (nColumnIndex) {
                case 0: {
                    if (tableData != null) {
                        return new Integer(tableData.getStatus());
                    }
                    return new Integer(0);
                }
                case 1: {
                    if (fieldDef != null) {
                        return fieldDef.getName();
                    }
                    return new String();
                }
                case 2: {
                    if (fieldDef != null) {
                        return VWFieldType.getLocalizedString(fieldDef.getFieldType());
                    }
                    return new String();
                }
                case 3: {
                    if (fieldDef != null && fieldDef.getFieldType() == 2) {
                        return Integer.toString(fieldDef.getLength());
                    }
                    return new String();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        boolean bEditable = false;
        try {
            VWConfigTableModelData tableData = this.getRowItemAt(nRowIndex);
            if (tableData == null) {
                return false;
            }
            VWExposedFieldDefinition fieldDef = (VWExposedFieldDefinition)tableData.getDefinition();
            switch (nColumnIndex) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    if (this.m_vwTableDef instanceof VWLogDefinition || fieldDef == null || fieldDef.getFieldType() != 2 || (tableData.getStatus() & 8) <= 0) break;
                    bEditable = true;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return bEditable;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                this.onUpdateFieldLength(aValue, nRowIndex);
            }
        }
    }

    public void releaseResources() {
        this.m_parentFrame = null;
        this.m_vwTableDef = null;
        if (this.m_rowData != null) {
            this.m_rowData.removeAllElements();
            this.m_rowData = null;
        }
        if (this.m_availableOptions != null) {
            this.m_availableOptions.removeAllElements();
            this.m_availableOptions = null;
        }
        if (this.m_selectedOptions != null) {
            this.m_selectedOptions.removeAllElements();
            this.m_selectedOptions = null;
        }
    }

    private void initialize() {
        VWExposedFieldDefinition[] exposedFields = null;
        VWConfigTableModelData tableData = null;
        VWExposedFieldDefinition fieldDef = null;
        int nStatus = 0;
        try {
            int nIndex;
            this.m_rowData = new Vector();
            this.m_availableOptions = new Vector();
            this.m_selectedOptions = new Vector();
            if (this.m_vwTableDef instanceof VWQueueDefinition) {
                exposedFields = VWQueueDefinition.optionalSystemFields();
            } else if (this.m_vwTableDef instanceof VWRosterDefinition) {
                exposedFields = VWRosterDefinition.optionalSystemFields();
            } else if (this.m_vwTableDef instanceof VWLogDefinition) {
                exposedFields = VWLogDefinition.optionalSystemFields();
            }
            if (exposedFields != null) {
                for (nIndex = 0; nIndex < exposedFields.length; ++nIndex) {
                    this.m_availableOptions.addElement(exposedFields[nIndex]);
                }
            }
            if ((exposedFields = this.m_vwTableDef.getFields()) != null) {
                for (nIndex = 0; nIndex < exposedFields.length; ++nIndex) {
                    if (!exposedFields[nIndex].isSystemField()) continue;
                    nStatus = 0;
                    if (!exposedFields[nIndex].isMandatorySystemField() && (fieldDef = this.moveToSelectedList(exposedFields[nIndex].getName())) != null) {
                        nStatus = 8;
                    }
                    if ((tableData = new VWConfigTableModelData(exposedFields[nIndex], nStatus)) == null) continue;
                    this.m_rowData.addElement(tableData);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onUpdateFieldLength(Object aValue, int nRowIndex) {
        VWConfigTableModelData tableData = null;
        VWExposedFieldDefinition fieldDef = null;
        try {
            if (aValue != null && (tableData = this.getRowItemAt(nRowIndex)) != null && (fieldDef = (VWExposedFieldDefinition)tableData.getDefinition()) != null) {
                fieldDef.setLength(Integer.parseInt(aValue.toString()));
                tableData.setDirty();
            }
            this.m_bIsModified = true;
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (NumberFormatException ex) {
            String msg = String.valueOf(nRowIndex + 1);
            if (fieldDef != null) {
                msg = msg + " (" + fieldDef.getName() + ")";
            }
            VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.InvalidDataFieldLength.toString(msg), VWResource.ErrorMessage, 1);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.ErrorMessage, 1);
        }
    }

    protected VWExposedFieldDefinition getFieldItemAt(int nRowIndex) {
        VWConfigTableModelData tableData = this.getRowItemAt(nRowIndex);
        if (tableData != null) {
            return (VWExposedFieldDefinition)tableData.getDefinition();
        }
        return null;
    }

    private VWConfigTableModelData getRowItemAt(int nRowIndex) {
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            return (VWConfigTableModelData)this.m_rowData.elementAt(nRowIndex);
        }
        return null;
    }

    private String[] getFieldNames(Vector fieldItems) {
        String[] fieldNames = null;
        try {
            if (fieldItems != null) {
                VWExposedFieldDefinition exposedField = null;
                fieldNames = new String[fieldItems.size()];
                for (int nIndex = 0; nIndex < fieldItems.size(); ++nIndex) {
                    exposedField = (VWExposedFieldDefinition)fieldItems.elementAt(nIndex);
                    fieldNames[nIndex] = new String(exposedField.getName());
                }
            }
            return fieldNames;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void moveToAvailableList(String name) {
        block3: {
            try {
                if (this.m_availableOptions == null || this.m_selectedOptions == null) break block3;
                for (int nIndex = 0; nIndex < this.m_selectedOptions.size(); ++nIndex) {
                    VWExposedFieldDefinition fieldDef = (VWExposedFieldDefinition)this.m_selectedOptions.elementAt(nIndex);
                    if (VWStringUtils.compare(name, fieldDef.getName()) != 0) continue;
                    this.m_selectedOptions.removeElementAt(nIndex);
                    this.m_availableOptions.addElement(fieldDef);
                    break;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    private VWExposedFieldDefinition moveToSelectedList(String name) {
        try {
            if (this.m_availableOptions != null && this.m_selectedOptions != null) {
                for (int nIndex = 0; nIndex < this.m_availableOptions.size(); ++nIndex) {
                    VWExposedFieldDefinition fieldDef = (VWExposedFieldDefinition)this.m_availableOptions.elementAt(nIndex);
                    if (VWStringUtils.compare(name, fieldDef.getName()) != 0) continue;
                    this.m_availableOptions.removeElementAt(nIndex);
                    this.m_selectedOptions.addElement(fieldDef);
                    return fieldDef;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }
}

